/*
 * priority.c - priority setting/retrieval DLL for mIRC
 * Copyright (c) 2006, D.C. van Moolenbroek, XISE <dc@xise.nl>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#define NCLASSES 6
static struct {
  DWORD class;
  char *name;
} classes[NCLASSES+1] = {
  { IDLE_PRIORITY_CLASS, "idle" },
  { BELOW_NORMAL_PRIORITY_CLASS, "below" },
  { NORMAL_PRIORITY_CLASS, "normal" },
  { ABOVE_NORMAL_PRIORITY_CLASS, "above" },
  { HIGH_PRIORITY_CLASS, "high" },
  { REALTIME_PRIORITY_CLASS, "realtime" },
  { 0, "unknown" }
};

int __export _stdcall get(HWND mWnd, HWND aWnd, char *data,
 char *parms, BOOL show, BOOL nopause) {
  DWORD i, p = GetPriorityClass(GetCurrentProcess());

  for (i = 0; i < NCLASSES; i++)
   if (classes[i].class == p) break;

  lstrcpy(data, classes[i].name);

  return 3;
}

int __export __stdcall set(HWND mWnd, HWND aWnd, char *data,
 char *parms, BOOL show, BOOL nopause) {
  DWORD i;

  for (i = 0; i < NCLASSES; i++)
   if (!lstrcmpi(data, classes[i].name)) {
     SetPriorityClass(GetCurrentProcess(), classes[i].class);

     break;
   }

  return 1;
}
